unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Normal1: TMenuItem;
    CourierNew1: TMenuItem;
    Arial1: TMenuItem;
    TimesNewRoman1: TMenuItem;
    Bold1: TMenuItem;
    CourierNew2: TMenuItem;
    Ariql1: TMenuItem;
    TimesNewRoman2: TMenuItem;
    Italic1: TMenuItem;
    CourierNew3: TMenuItem;
    Arial2: TMenuItem;
    TimesNewRoman3: TMenuItem;
    Cores1: TMenuItem;
    ff1: TMenuItem;
    ff001: TMenuItem;
    ff00001: TMenuItem;
    N01: TMenuItem;
    ffffff1: TMenuItem;
    c0c0c01: TMenuItem;
    ffff1: TMenuItem;
    ffff001: TMenuItem;
    ff00ff1: TMenuItem;
    procedure CourierNew1DrawItem(Sender: TObject; ACanvas: TCanvas;
      ARect: TRect; Selected: Boolean);
    procedure TimesNewRoman2DrawItem(Sender: TObject; ACanvas: TCanvas;
      ARect: TRect; Selected: Boolean);
    procedure TimesNewRoman3DrawItem(Sender: TObject; ACanvas: TCanvas;
      ARect: TRect; Selected: Boolean);
    procedure CoresDrawItem(Sender: TObject; ACanvas: TCanvas;
      ARect: TRect; Selected: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.CourierNew1DrawItem(Sender: TObject; ACanvas: TCanvas;
  ARect: TRect; Selected: Boolean);
begin
  ACanvas.Font.Name := (Sender as TMenuItem).Caption;
  ACanvas.TextOut(ARect.Left+1,ARect.Top+1,(Sender as TMenuItem).Caption);
end;

procedure TForm1.TimesNewRoman2DrawItem(Sender: TObject; ACanvas: TCanvas;
  ARect: TRect; Selected: Boolean);
var
  dwCheck : Integer;
  MenuText : String;
begin
// pega as dimenses da marca de check do menu
  dwCheck := GetSystemMetrics(SM_CXMENUCHECK);
// acerta posio da esquerda para checkmark
  ARect.Left := ARect.Left +  LoWord(dwCheck);
  MenuText := (Sender as TMenuItem).Caption;
  ACanvas.Font.Name := MenuText;
  ACanvas.Font.Style := [fsBold];
// Desenha o texto
  ExtTextOut(ACanvas.Handle,ARect.Left,ARect.Top,
                 ETO_OPAQUE,@ARect,PChar(MenuText),Length(MenuText),NIL);
end;

procedure TForm1.TimesNewRoman3DrawItem(Sender: TObject; ACanvas: TCanvas;
  ARect: TRect; Selected: Boolean);
begin
  ACanvas.Font.Name := (Sender as TMenuItem).Caption;
  ACanvas.Font.Style := [fsItalic];
  ACanvas.TextOut(ARect.Left+1,ARect.Top+1,(Sender as TMenuItem).Caption);
end;

procedure TForm1.CoresDrawItem(Sender: TObject; ACanvas: TCanvas;
  ARect: TRect; Selected: Boolean);
var
  dwCheck : Integer;
  MenuColor : TColor;
begin
// pega as dimenses da marca de check do menu
  dwCheck := GetSystemMetrics(SM_CXMENUCHECK);
// acerta posio da esquerda para checkmark
  ARect.Left := ARect.Left +  LoWord(dwCheck);
  MenuColor := TColor(StrToInt((Sender as TMenuItem).Caption));
// Cor de fundo  aquela dada pelo Caption
  ACanvas.Brush.Color := MenuColor;
// Desenha o retngulo
  if Selected then
    ACanvas.Pen.Style := psSolid
  else
    ACanvas.Pen.Style := psClear;
  ACanvas.Rectangle(ARect.Left,ARect.Top,ARect.Right,ARect.Bottom);
end;

end.
